#include <SPI.h>
#include <Ethernet2.h>

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xAF};
IPAddress ip(192, 168, 104, 177);
//IPAddress ip(192, 168, 0, 177);

// int a; //переменные для вычисления аналоговых уровней
float fc;
String MyIp;

boolean newInfo = 0; //переменная для новой информации

// Initialize the Ethernet server library
// with the IP address and port you want to use
// (port 80 is default for HTTP):
EthernetServer server(80);



  
void setup() {

  pinMode (4, OUTPUT);//розетка
  pinMode (3, OUTPUT);//TX switch
  pinMode (2, OUTPUT);//W5500 reset switch
  digitalWrite (4, LOW); 
  digitalWrite (3, LOW); 
  digitalWrite (2, LOW); 
  delay (100);
  digitalWrite (2, HIGH);
  delay (50);
  digitalWrite (2, LOW); //set reset w5500
  delay (50);  
  Ethernet.begin(mac, ip);
  server.begin();
  MyIp = String (Ethernet.localIP());


}



float analog(int paramA, float paramB, float paramC) {
  int sensorReading = analogRead(paramA);
  return ((sensorReading * paramB * paramC) / 1024);
}


void loop() {

 if (MyIp != String (Ethernet.localIP())) {
  digitalWrite (2, HIGH);
  delay (50);
  digitalWrite (2, LOW); //set reset w5500
  Ethernet.begin(mac, ip);
  server.begin();
  delay (100);
 }

  
  EthernetClient client = server.available(); //принимаем данные, посылаемые клиентом
  if (client) { //если запрос оканчивается пустой строкой
    boolean currentLineIsBlank = true;
    //ставим метку об окончании запроса (дословно: текущая линия чиста)
    while (client.connected()) { //пока есть соединение с клиентом
      if (client.available()) { //если клиент активен
        char c = client.read(); //считываем посылаемую информацию в переменную "с"
        if (newInfo && c == ' ') {
          //если переменная новой информации = 1 и "с", в которой записан запрос, равен пустой строке
          newInfo = 0; //то обнуляем переменную поступления новой информации
        }
        if (c == '$') {
          // если переменная "с", несущая отправленный нам запрос, содержит символ $
          // "$" подразумевает разделение получаемой информации (символов)
          newInfo = 1; //то пришла новая информация, ставим метку новой информации в 1
        }
        //Проверяем содержание URL - присутствует $1, $2
        if (newInfo == 1) { //если есть новая информация
          if (c == '1') { //и "с" содержит 1
            digitalWrite (4, HIGH); //розетка off
          }
          if (c == '2') { //если "с" содержит 2
            digitalWrite (4, LOW); //розетка on
          }
          if (c == '3') { //и "с" содержит 1
            digitalWrite (3, HIGH); //розетка off
          }
          if (c == '4') { //если "с" содержит 2
            digitalWrite (3, LOW); //розетка on
          }          
        }
        delay(2);
        if (c == '\n') { //если "с" равен символу новой строки
          currentLineIsBlank = true; //то начинаем новую строку
        }
        else if (c != '\r') {
          //иначе, если "с" не равен символу возврата курсора на начало строки
          currentLineIsBlank = false; //то получаем символ на текущей строке
        }


        if (c == '\n' && currentLineIsBlank) { //выводим HTML страницу
          client. println ("HTTP/1.1 200 OK"); //заголовочная информация
          client. println ("Content-Type: text/html");
          client. println ("Connection: close");
          client. println ("Refresh: 5"); //автоматическое обновление каждые 5 сек
          client. println (); //Это не ошибка, так должно быть
//          client. println ("<!DOCTYPE HTML>"); //HTML тип документа
          client. println ("<html>"); //открытие тега HTML
          client. println ("<head> "); //открытие тега Head
          client. println ("<meta http-equiv='Content-Type' content='text/html ; charset=utf-8'/> ");
          client. println ("<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\"> ");
//          client. println ("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"> ");
          client. print ("<title>TLM</title>"); //название страницы
          client. println ("</head>"); //заголовочная информация
          client. println ("<body>");
          client. print ("<H1>Galugaevskaya</H1>"); //заголовк на странице
          client. print ("<b>TX Vera 89.8</b>");
          client.println("<br />");
          client.print("FWD PWR = ");
          fc = analog(0, 5, 5.1);
          client.print(fc);
          client.print(" W");
          client.println("<br />");
          fc = analog(1, 0.75, 5.1);
          client.print("REF = ");
          client.print(fc);        
          client.print(" W");
          client.println("<br />");
          fc = analog(2, 0.19, 5.1);
          client.print("Audio = ");
          client.print(fc);
          client.print(" V");
          client.println("<br />");
           client.println("<br />");

          client. print ("<a href=\"/$1\"><button>PC OFF</button></a>");
          //кнопка включить
          client. print ("<a href=\"/$2\"><button>PC ON</button></a>");
          //кнопка выключить
          client. println ("<br>"); //перенос на след. строчку
           client.println("<br />");
           client. print ("<a href=\"/$3\"><button>TX OFF</button></a>");
          //кнопка включить
          client. print ("<a href=\"/$4\"><button>TX ON</button></a>");
          //кнопка выключить         
          client. println ("<hr/>"); //линия=====================================
          client. println ("<br>"); //перенос на след. строчку
          client. println ("168-TU");
          client. println ("</body>");
          client. println ("</html>"); //закрываем тег HTML
          
          break; //выход
        }
      }
    }
    delay (1); //время на получение новых данных
    client.stop(); //закрываем соеднение
  }
}
